/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_04;
import java.awt.*; import lotus.domino.*; import java.net.URLDecoder;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class AppletAwt extends AppletBase {

	private Graphics graphics;
	private Label user, localInfo, serverInfo;
	private String text = "", server = "";
	public Session session;
 
	public void notesAppletInit() {
		graphics = getGraphics();
		user = new Label ("");
		localInfo = new Label ("");
		serverInfo = new Label ("");
		add (user);
		add (localInfo);
		add (serverInfo);
		setVisible(true);
	}

	public void notesAppletStart() {
		try {
			if (isNotesLocal()) {
				session = this.getSession ();
			} else {
				session = this.getSession("", "");
			}
			NotesAppletContext nac=null;
			try {
				nac = getContext(session);
			} catch (NotesException ne) {
				//ignore - Diese Exception tritt nur auf, falls ber IDE gestartet.
				//der Applet Context kann nur ber Domino (Client oder Browser) 
				//bezogen werden.
			}
			server = (nac!=null?URLDecoder.decode(nac.getServer())
					+ "!!" + nac.getDatabase().getFilePath():"");
			text = "Benutzer: " + session.getCommonUserName();
			serverInfo.setText (server);
			localInfo.setText("AWT Example: " + (isNotesLocal()?"Lokal":"Remote"));
			user.setText(text);
		} catch (NotesException e) {
			System.err.println (e.id + " " + e.text);
		} catch (Exception e) {
			e.printStackTrace(System.err);
		} finally {
			try {
				this.closeSession(session);
			} catch (NotesException e) {
				e.printStackTrace();
			}
		}
	}
	
	public void paint(Graphics g) {
		localInfo.setLocation(0,20); localInfo.setSize(200,50);
		serverInfo.setLocation(0,50); serverInfo.setSize(200,50);
		user.setLocation(0,80); user.setSize(200,50);
	}
}